up:: [[The 3 Phases of MOCs]]
tags:: #map #on/habit 

> [!NOTE]+ Navigate with your new MOC
> Connect your new MOC with the the rest of your network of knowledge so you can *navigate your notes near the speed of thought*. 
> 
> Enjoy the spatial constellation you created. Your MOCs will be meaningful to you. 
> 
> Use your more mature MOCs for different purposes:
> - for final products (content creation)
> - as a reference point in the future, as a navigational hub
> - for the inherent joy the ideas provide.
>
> As you finish work on an area of interest, the MOC remains as a renewable summation of thought for the future you. An MOC is your easy access point back into the topic—whether that's tomorrow or in ten years. 
>
> Below is an assembly of the notes in some sort of formalized structure. I have continued adding to this whenever it made sense.

# Habits MOC
*I am an unrelenting evolutionary adaptation—whether you like it or not!*

## Understanding Habits
- [[Defining a habit]]
- [[Habit formation provides an evolutionary advantage]]
- [[Habits carry a ton of hidden inertia]]
- [[The neural formation of habits is additive]]
	- [[The truest habit metaphors are additive]]
	- [[Ant pheromone trails act like potential habits]]

## Designing Habits
- [[Understanding the habit cycle and habitual cues]]
	- [[How Atomic Habits fit into the conversation on habits]]
	- [[Resiliency Routines help regain a sense of control]]
	- [[Improving Micro Habits at the Point of Contact]]
- [[Small Wins foster a Sense of Control]]
- [[An asymptotic curve models the development of skills, strength, habits, and more]]
	- [[The mechanism for breaking through development plateaus]]

### Example of Habit Design
- [[Charting out habit cycles in my life circa 2013]]

### Important Habits
[[Being able to adapt is an important habit]]
[[Important habits preserve mental clarity and a sense of control]]
[[Preparing for the next day is an important habit]]
[[Journaling in the morning is an important habit]]
[[Writing down daily goals in the morning is an important habit]]


## Related Concepts
[[Feedback Loop]], [[Like begets like]]
[[Cobwebs into Cables]], [[Reps]], [[Sense of Control]]
[[Natural Selection]], [[Selfish Gene]], [[Survival of the Fittest]]
[[Flywheel Effect]], 

## Other Miscellaneous
 - [[Words I've used to describe important habits]]


[[Changing a habit is really about replacing a routine]]

---

Finish the walkthrough: [[The 3 Phases of MOCs, a coda]]

---


## LYT Vision
Activate "LYT Vision" to resurface thoughts in context. When you twirl this open, it's like you are putting on night vision goggles: you see things hidden in the shadows.

The main contextual queries I prefer are "unrequited" & "unmentioned" notes. 

### Unrequited notes, by link
These notes point directly to this note. But this note doesn't point back.
```dataview
table file.mtime.year + "-" + file.mtime.month + "-" + file.mtime.day as Modified
from [[Habits MOC]]
and !outgoing([[Habits MOC]])
sort file.mtime desc
```

### Unmentioned notes, with related tag
These notes have the tag `#` and are not mentioned above.

```dataview
table file.mtime.year + "-" + file.mtime.month + "-" + file.mtime.day as Modified
from #on/habit 
and !outgoing([[Habits MOC]])
sort file.mtime desc
```


